/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CherryLeavesBlock
extends LeavesBlock {
    public static final BooleanProperty VARIANT = BooleanProperty.m_61465_((String)"can_have_cherries");
    public static final BooleanProperty HAS_CHERRIES = BooleanProperty.m_61465_((String)"has_cherries");
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public CherryLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)VARIANT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_CHERRIES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)VARIANT)).booleanValue() && ((Boolean)state.m_61143_((Property)HAS_CHERRIES)).booleanValue()) {
            if (!world.m_5776_()) {
                int dropCount = world.m_213780_().m_188499_() ? world.m_213780_().m_216339_(1, 4) : 1;
                ItemStack dropStack = new ItemStack((ItemLike)ObjectRegistry.CHERRY.get(), dropCount);
                if (world.m_213780_().m_188503_(8) == 0) {
                    dropStack = new ItemStack((ItemLike)ObjectRegistry.ROTTEN_CHERRY.get(), dropCount);
                }
                CherryLeavesBlock.m_152435_((Level)world, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)dropStack);
                world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)HAS_CHERRIES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)VARIANT) != false && (Boolean)state.m_61143_((Property)HAS_CHERRIES) == false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Player p = ctx.m_43723_();
        boolean b = p != null && p.m_6144_();
        return (BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(ctx)).m_61124_((Property)VARIANT, (Comparable)Boolean.valueOf(ctx.m_43723_().m_150110_().f_35937_ && b))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT, HAS_CHERRIES, AGE});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        double growthChance = PlatformHelper.getCherryGrowthChance();
        if (age < 3 && random.m_188500_() < growthChance && this.canGrowPlace((LevelReader)world, pos)) {
            BlockState newState = age + 1 >= 3 ? (BlockState)((BlockState)state.m_61124_((Property)HAS_CHERRIES, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)) : (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            world.m_7731_(pos, newState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        }
        super.m_213898_(state, world, pos, random);
    }

    private boolean canGrowPlace(LevelReader world, BlockPos pos) {
        return world.m_45524_(pos, 0) > 9;
    }
}

